SET TERM ^ ;



CREATE OR ALTER TRIGGER RELACIONA_PROCESSO FOR REQUISITORIOS
ACTIVE AFTER INSERT OR UPDATE POSITION 3
AS
DECLARE VARIABLE COD_DADOS DOM_CODIGO;
BEGIN
  IF ((NEW.PROCESSO_CNJ IS NOT NULL) AND
      (TRIM(NEW.PROCESSO_CNJ) <> '') AND
      (NEW.COD_DADOS IS NULL)) THEN
  BEGIN
    IF (NEW.SEQ_RECURSO > 0) THEN
    BEGIN
      COD_DADOS = 0;
      SELECT FIRST 1 DADOS.CODIGO
      FROM DADOS
      WHERE DADOS.PROCESSO_CNJ = NEW.PROCESSO_CNJ AND
            DADOS.SEQ_RECURSO = NEW.SEQ_RECURSO
      INTO :COD_DADOS;
    END
    ELSE
    BEGIN
      COD_DADOS = 0;
      SELECT FIRST 1 DADOS.CODIGO
      FROM DADOS
      WHERE DADOS.PROCESSO_CNJ = NEW.PROCESSO_CNJ AND
            DADOS.SEQ_RECURSO IS NULL
      INTO :COD_DADOS;

    END
    IF (:COD_DADOS > 0) THEN
    BEGIN
      UPDATE REQUISITORIOS
      SET REQUISITORIOS.COD_DADOS = :COD_DADOS
      WHERE REQUISITORIOS.CODIGO = NEW.CODIGO;
    END
  END
END
^
SET TERM ; ^